//
//  Utils.swift
//  spheroArcade
//
//  Created by Jeff Payan on 2017-03-20.
//  Copyright © 2018 Sphero Inc. All rights reserved.
//

import UIKit

extension UIViewController {
    
    public static func instantiateFromStoryboard<T>() -> T {
        let bundle = Bundle(for: T.self as! AnyClass)
        let storyboard = UIStoryboard(name: "SpheroArcade", bundle: bundle)
        let identifier = String(describing: self)
        
        return storyboard.instantiateViewController(withIdentifier: identifier) as! T
    }
    
}

extension UIView {
    public func pinEdges(to view: UIView) {
        NSLayoutConstraint.activate([
            view.leadingAnchor.constraint(equalTo: self.leadingAnchor),
            view.topAnchor.constraint(equalTo: self.topAnchor),
            view.bottomAnchor.constraint(equalTo: self.bottomAnchor),
            view.trailingAnchor.constraint(equalTo: self.trailingAnchor),
            ])
    }
}

extension UIFont {
    
    public static let arcadeFontName: String = {
        let fontUrl = Bundle.main.url(forResource: "slkscr", withExtension: "ttf")!
        CTFontManagerRegisterFontsForURL(fontUrl as CFURL, CTFontManagerScope.process, nil)
        return "Silkscreen"
    }()
    
    public class func arcadeFont(ofSize fontSize: CGFloat) -> UIFont {
        return UIFont(name: arcadeFontName, size: 25.0)!
    }
    
}


private let angleDescriptions: [(Double,String)] = [
    (0.0,    NSLocalizedString("SpheroSimulator_AngleDescription_Forward",     value: "Forward",      comment: "VoiceOver description for Sphero heading Forward")),
    (45.0,   NSLocalizedString("SpheroSimulator_AngleDescription_ForwardRight", value: "Forward Right", comment: "VoiceOver description for Sphero heading Forward Right")),
    (90.0,   NSLocalizedString("SpheroSimulator_AngleDescription_Right",      value: "Right",       comment: "VoiceOver description for Sphero heading Right")),
    (135.0,  NSLocalizedString("SpheroSimulator_AngleDescription_BackwardRight", value: "Backward Right", comment: "VoiceOver description for Sphero heading Backward Right")),
    (180.0,  NSLocalizedString("SpheroSimulator_AngleDescription_Backward",     value: "Backward",      comment: "VoiceOver description for Sphero heading Backward")),
    (-135.0, NSLocalizedString("SpheroSimulator_AngleDescription_BackwardLeft", value: "Backward Left", comment: "VoiceOver description for Sphero heading Backward Left")),
    (-90.0,  NSLocalizedString("SpheroSimulator_AngleDescription_Left",      value: "Left",       comment: "VoiceOver description for Sphero heading Left")),
    (-45.0,  NSLocalizedString("SpheroSimulator_AngleDescription_ForwardLeft", value: "Forward Left", comment: "VoiceOver description for Sphero heading Forward Left"))
]

extension Double {

    public func angleDescription() -> String {
        var bestDescription = ""
        var minAngleDistance = 360.0
        
        for (angle, description) in angleDescriptions {
            let distance = abs((angle - self).canonizedAngle())
            
            if distance < minAngleDistance {
                minAngleDistance = distance
                bestDescription = description
            }
        }
        
        return bestDescription
    }
    
}

struct ColorPalette {
    struct SpheroBopIt {
        static let TapBackground = UIColor(red: 239.0/255.0, green: 81.0/255.0, blue: 57.0/255.0, alpha: 1.0)
        static let ShakeBackground = UIColor(red: 255.0/255.0, green: 152.0/255.0, blue: 37.0/255.0, alpha: 1.0)
        static let SpinBackground = UIColor(red: 170.0/255.0, green: 198.0/255.0, blue: 52.0/255.0, alpha: 1.0)
        static let TossBackground = UIColor(red: 255.0/255.0, green: 214.0/255.0, blue: 65.0/255.0, alpha: 1.0)
        static let RandomGameBackground = UIColor(red: 255.0/255.0, green: 110.0/255.0, blue: 81.0/255.0, alpha: 1.0)
        static let DifficultyRampBackground = UIColor(red: 117.0/255.0, green: 186.0/255.0, blue: 87.0/255.0, alpha: 1.0)
        static let CustomGestureBackground = UIColor(red: 255.0/255.0, green: 137.0/255.0, blue: 81.0/255.0, alpha: 1.0)

    }
    
    struct SpheroPacMan {
        static let PacManBackground = UIColor(red: 130.0/255.0, green: 59.0/255.0, blue: 137.0/255.0, alpha: 1.0)
        static let ScoringBackground = UIColor(red: 102.0/255.0, green: 150.0/255.0, blue: 253.0/255.0, alpha: 1.0)
        static let PowerUpsBackground = UIColor(red: 217.0/255.0, green: 84.0/255.0, blue: 137.0/255.0, alpha: 1.0)
        static let BasicGhostsBackground = UIColor(red: 69.0/255.0, green: 189.0/255.0, blue: 255.0/255.0, alpha: 1.0)
        static let AdvancedGhostBackground = UIColor(red: 115.0/255.0, green: 73.0/255.0, blue: 230.0/255.0, alpha: 1.0)
        
        struct Ghost {
            static let Inky = UIColor(red: 238.0/255.0, green: 99.0/255.0, blue: 154.0/255.0, alpha: 1.0)
            static let Pinky = UIColor(red: 73.0/255.0, green: 208.0/255.0, blue: 194.0/255.0, alpha: 1.0)
            static let Blinky = UIColor(red: 239.0/255.0, green: 164.0/255.0, blue: 43.0/255.0, alpha: 1.0)
            static let Clyde = UIColor(red: 186.0/255.0, green: 209.0/255.0, blue: 25.0/255.0, alpha: 1.0)

        }
    }
}
